import random
import numpy as np
from pettingzoo import ParallelEnv

class MultiConfigWrapper(ParallelEnv):
    def __init__(self, env,
                 configs=None,
                 prob_configs=None,
                 sampling_method='random'):
        self.env = env
        self.configs = configs
        self.prob_configs = prob_configs
        self.sampling_method = sampling_method
        self.random_state = np.random.RandomState()

        self.current_config_index = 0

        self.possible_agents = self.env.possible_agents
        self.observation_spaces = self.env.observation_spaces
        self.action_spaces = self.env.action_spaces

    def _select_config(self):
        if self.sampling_method == 'random':
            return self.np_random.choice(self.configs_list)
        elif self.sampling_method == 'round_robin':
            config = self.configs_list[self.current_config_index]
            self.current_config_index = (self.current_config_index + 1) % len(self.configs_list)
            return config
        else:
            raise ValueError("Invalid sampling method. Choose 'random' or 'round_robin'.")
     
    def reset(self, seed=None, options=None):
        config = self._select_config()
        options = {"config", config}
        return self.env.reset(seed, options)